VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Form1"
   ClientHeight    =   2470
   ClientLeft      =   50
   ClientTop       =   340
   ClientWidth     =   4430
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2470
   ScaleWidth      =   4430
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   720
      TabIndex        =   0
      Top             =   720
      Width           =   3015
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Type TTestBarcode
   BarcodeType As TPDFBarcodeType
   BarcodeName As String
   DataType As TPDFBarcodeDataType
   Data As String
   Primary As String
End Type

Private Sub Init(ByRef b As TTestBarcode, ByVal BcdType As TPDFBarcodeType, ByVal Name As String, ByVal DtaType As TPDFBarcodeDataType, ByVal Dta As String, ByVal Prmy As String)
   b.BarcodeType = BcdType
   b.BarcodeName = Name
   b.DataType = DtaType
   b.Data = Dta
   b.Primary = Prmy
End Sub


Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = True ' We break processing if an error occurred!
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub

Private Sub Command1_Click()
   Dim TEST_CODES() As TTestBarcode
   ReDim TEST_CODES(93)
   
   Call Init(TEST_CODES(0), bctAustraliaPost, "Australia Post", bcdtBinary, "12345678", "")
   Call Init(TEST_CODES(1), bctAustraliaRedir, "Australia Redirect Code", bcdtBinary, "12345678", "")
   Call Init(TEST_CODES(2), bctAustraliaReply, "Australia Reply-Paid", bcdtBinary, "12345678", "")
   Call Init(TEST_CODES(3), bctAustraliaRout, "Australia Routing Code", bcdtBinary, "12345678", "")
   Call Init(TEST_CODES(4), bctAztec, "Aztec binary mode", bcdtBinary, "123456789012", "")
   Call Init(TEST_CODES(5), bctAztec, "Aztec GS1 Mode", bcdtGS1Mode, "[01]03453120000011[17]120508[10]ABCD1234[410]9501101020917", "")
   Call Init(TEST_CODES(6), bctAztecRunes, "Aztec Runes", bcdtBinary, "123", "")
   Call Init(TEST_CODES(7), bctC2Of5IATA, "Code 2 of 5 IATA", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(8), bctC2Of5Industrial, "Code 2 of 5 Industrial", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(9), bctC2Of5Interleaved, "Code 2 of 5 Interleaved", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(10), bctC2Of5Logic, "Code 2 of 5 Data Logic", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(11), bctC2Of5Matrix, "Code 2 of 5 Matrix", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(12), bctChannelCode, "Channel Code", bcdtBinary, "1234567", "")
   Call Init(TEST_CODES(13), bctCodabar, "Codabar", bcdtBinary, "A123456789B", "")
   Call Init(TEST_CODES(14), bctCodablockF, "Codablock-F", bcdtBinary, "1234567890abcdefghijklmnopqrstuvwxyz", "")
   Call Init(TEST_CODES(15), bctCode11, "Code 11", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(16), bctCode128, "Code 128", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(17), bctCode128B, "Code 128", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(18), bctCode16K, "Code 16K binary mode", bcdtBinary, "[90]A1234567890", "")
   Call Init(TEST_CODES(19), bctCode16K, "Code 16K GS1 mode", bcdtGS1Mode, "[90]A1234567890", "")
   Call Init(TEST_CODES(20), bctCode32, "Code 32", bcdtBinary, "12345678", "")
   Call Init(TEST_CODES(21), bctCode39, "Code 39", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(22), bctCode49, "Code 49", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(23), bctCode93, "Code 93", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(24), bctCodeOne, "Code One", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(25), bctDAFT, "DAFT Code", bcdtBinary, "aftdaftdftaft", "")
   Call Init(TEST_CODES(26), bctDataBarOmniTrunc, "GS1 DataBar Omnidirectional", bcdtBinary, "0123456789012", "")
   Call Init(TEST_CODES(27), bctDataBarExpStacked, "GS1 DataBar Stacked", bcdtBinary, "[90]1234567890", "")
   Call Init(TEST_CODES(28), bctDataBarExpanded, "GS1 DataBar Expanded", bcdtBinary, "[90]1234567890", "")
   Call Init(TEST_CODES(29), bctDataBarLimited, "GS1 DataBar Limited", bcdtBinary, "0123456789012", "")
   Call Init(TEST_CODES(30), bctDataBarStacked, "GS1 DataBar Stacked", bcdtBinary, "0123456789012", "")
   Call Init(TEST_CODES(31), bctDataBarStackedO, "GS1 DataBar Stacked Omni", bcdtBinary, "0123456789012", "")
   Call Init(TEST_CODES(32), bctDataMatrix, "Data Matrix ISO 16022", bcdtBinary, "0123456789012", "")
   Call Init(TEST_CODES(33), bctDotCode, "DotCode", bcdtBinary, "0123456789012", "")
   Call Init(TEST_CODES(34), bctDPD, "DPD Code", bcdtBinary, "1234567890123456789012345678", "")
   Call Init(TEST_CODES(35), bctDPIdentCode, "Deutsche Post Identcode", bcdtBinary, "12345678901", "")
   Call Init(TEST_CODES(36), bctDPLeitcode, "Deutsche Post Leitcode", bcdtBinary, "1234567890123", "")
   Call Init(TEST_CODES(37), bctEAN128, "EAN 128", bcdtBinary, "[90]0101234567890128TEC-IT", "")
   Call Init(TEST_CODES(38), bctEAN128_CC, "EAN 128 Composite Code", bcdtBinary, "[10]1234-1234", "[90]123456")
   Call Init(TEST_CODES(39), bctEAN14, "EAN 14", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(40), bctEANX, "EAN X", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(41), bctEANX_CC, "EAN Composite Symbol", bcdtBinary, "[90]12341234", "12345678")
   Call Init(TEST_CODES(42), bctEANXCheck, "EAN + Check Digit", bcdtBinary, "12345", "")
   Call Init(TEST_CODES(43), bctExtCode39, "Ext. Code 3 of 9 (Code 39+)", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(44), bctFIM, "FIM", bcdtBinary, "d", "")
   Call Init(TEST_CODES(45), bctFlattermarken, "Flattermarken", bcdtBinary, "11111111111111", "")
   Call Init(TEST_CODES(46), bctHIBC_Aztec, "HIBC Aztec Code", bcdtBinary, "123456789012", "")
   Call Init(TEST_CODES(47), bctHIBC_CodablockF, "HIBC Codablock-F", bcdtBinary, "1234567890abcdefghijklmnopqrstuvwxyz", "")
   Call Init(TEST_CODES(48), bctHIBC_Code128, "HIBC Code 128", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(49), bctHIBC_Code39, "HIBC Code 39", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(50), bctHIBC_DataMatrix, "HIBC Data Matrix", bcdtBinary, "0123456789012", "")
   Call Init(TEST_CODES(51), bctHIBC_MicroPDF417, "HIBC Micro PDF417", bcdtBinary, "01234567890abcde", "")
   Call Init(TEST_CODES(52), bctHIBC_PDF417, "HIBC PDF417", bcdtBinary, "01234567890abcde", "")
   Call Init(TEST_CODES(53), bctHIBC_QR, "HIBC QR Code", bcdtBinary, "01234567890abcde", "")
   Call Init(TEST_CODES(54), bctISBNX, "ISBN (EAN-13 with validation)", bcdtBinary, "0123456789", "")
   Call Init(TEST_CODES(55), bctITF14, "ITF-14", bcdtBinary, "0123456789", "")
   Call Init(TEST_CODES(56), bctJapanPost, "Japanese Postal Code", bcdtBinary, "0123456789", "")
   Call Init(TEST_CODES(57), bctKIX, "Dutch Post KIX Code", bcdtBinary, "0123456789", "")
   Call Init(TEST_CODES(58), bctKoreaPost, "Korea Post", bcdtBinary, "123456", "")
   Call Init(TEST_CODES(59), bctLOGMARS, "LOGMARS", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(60), bctMailmark, "Royal Mail 4-State Mailmark", bcdtBinary, "11210012341234567AB19XY1A", "")
   Call Init(TEST_CODES(61), bctMaxicode, "Maxicode", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(62), bctMicroPDF417, "Micro PDF417", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(63), bctMicroQR, "Micro QR Code", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(64), bctMSIPlessey, "MSI Plessey", bcdtBinary, "12345678901", "")
   Call Init(TEST_CODES(65), bctNVE18, "NVE-18", bcdtBinary, "1234567890123456", "")
   Call Init(TEST_CODES(66), bctPDF417, "PDF417", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(67), bctPDF417Truncated, "PDF417 Truncated", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(68), bctPharmaOneTrack, "Pharmacode One-Track", bcdtBinary, "123456", "")
   Call Init(TEST_CODES(69), bctPharmaTwoTrack, "Pharmacode Two-Track", bcdtBinary, "123456", "")
   Call Init(TEST_CODES(70), bctPLANET, "PLANET", bcdtBinary, "12345678901", "")
   Call Init(TEST_CODES(71), bctPlessey, "Plessey", bcdtBinary, "12345678901", "")
   Call Init(TEST_CODES(72), bctPostNet, "PostNet", bcdtBinary, "12345678901", "")
   Call Init(TEST_CODES(73), bctPZN, "PZN", bcdtBinary, "1234567", "")
   Call Init(TEST_CODES(74), bctQRCode, "QR Code", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(75), bctRMQR, "Rect. Micro QR Code (rMQR)", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(76), bctRoyalMail4State, "Royal Mail 4 State (RM4SCC)", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(77), bctRSS_EXP_CC, "CS GS1 DataBar Ext. component", bcdtBinary, "[90]12341234", "[10]12345678")
   Call Init(TEST_CODES(78), bctRSS_EXPSTACK_CC, "CS GS1 DataBar Exp. Stacked", bcdtBinary, "[90]12341234", "[10]12345678")
   Call Init(TEST_CODES(79), bctRSS_LTD_CC, "CS GS1 DataBar Limited", bcdtBinary, "[90]12341234", "1234567")
   Call Init(TEST_CODES(80), bctRSS14_CC, "CS GS1 DataBar-14 Linear", bcdtBinary, "[90]12341234", "1234567")
   Call Init(TEST_CODES(81), bctRSS14Stacked_CC, "CS GS1 DataBar-14 Stacked", bcdtBinary, "[90]12341234", "1234567")
   Call Init(TEST_CODES(82), bctRSS14StackOMNI_CC, "CS GS1 DataBar-14 Stacked Omni", bcdtBinary, "[90]12341234", "1234567")
   Call Init(TEST_CODES(83), bctTelepen, "Telepen Alpha", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(84), bctUltracode, "Ultracode", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(85), bctUPCA, "UPC A", bcdtBinary, "1234567890", "")
   Call Init(TEST_CODES(86), bctUPCA_CC, "CS UPC A linear", bcdtBinary, "[90]12341234", "1234567")
   Call Init(TEST_CODES(87), bctUPCACheckDigit, "UPC A + Check Digit", bcdtBinary, "12345678905", "")
   Call Init(TEST_CODES(88), bctUPCE, "UCP E", bcdtBinary, "1234567", "")
   Call Init(TEST_CODES(89), bctUPCE_CC, "CS UPC E linear", bcdtBinary, "[90]12341234", "1234567")
   Call Init(TEST_CODES(90), bctUPCECheckDigit, "UCP E + Check Digit", bcdtBinary, "12345670", "")
   Call Init(TEST_CODES(91), bctUPNQR, "UPNQR (Univ. Placilni Nalog QR)", bcdtBinary, "1234567890abcdef", "")
   Call Init(TEST_CODES(92), bctUSPSOneCode, "USPS OneCode", bcdtBinary, "01234567094987654321", "")
   Call Init(TEST_CODES(93), bctVIN, "Vehicle Ident Number (USA)", bcdtBinary, "01234567094987654", "")

   ' Error messages and warnings are passed to the error event function.
   Call pdf.CreateNewPDF(vbNullString) ' The ouput file is opened later

   Call pdf.SetPageCoords(TPageCoord.pcTopDown)

   Dim bcd As TPDFBarcode2
   Call pdf.InitBarcode2(bcd)

   bcd.Options = bcoDefault Or bcoUseActiveFont
   ' Use this flag if you want to create image based barcodes
   'bcd.Options = bcoImageOutput

   Dim x, y, pw, ph, w, h, incX, incY As Double
   Dim i, cnt, xx, yy, nx, ny As Long
   Dim b As TTestBarcode

   cnt = UBound(TEST_CODES)

   pw = pdf.GetPageWidth - 100#
   ph = pdf.GetPageHeight - 100#
   w = 100#
   h = 120#
   nx = Int(pw / w)
   ny = Int(ph / h)
   incX = w + (pw - nx * w) / (nx - 1)
   incY = h + (ph - ny * h) / (ny - 1)
   h = 100#
   i = 0

   While i < cnt
      pdf.Append
         Call pdf.SetFont("Helvetica", TFStyle.fsRegular, 6.5, True, TCodepage.cp1252)
         Call pdf.SetLineWidth(0#)
         y = 50#
         For yy = 1 To ny
            x = 50#
            For xx = 1 To nx
               b = TEST_CODES(i)
               bcd.BarcodeType = b.BarcodeType
               bcd.Data = b.Data
               bcd.DataType = b.DataType
               bcd.Primary = b.Primary
               Call pdf.WriteFTextEx(x, y - 10#, w, -1#, taCenter, b.BarcodeName)
               Call pdf.Rectangle(x, y, w, h, fmStroke)
               Call pdf.InsertBarcode(x, y, w, h, coCenter, coCenter, bcd)
               i = i + 1
               x = x + incX
               If i = cnt Then Exit For
            Next xx
            y = y + incY
            If i = cnt Then Exit For
         Next yy
      pdf.EndPage
   Wend

   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim OutFile As String
      OutFile = App.Path + "\out.pdf"
      If pdf.OpenOutputFile(OutFile) Then
         If pdf.CloseFile Then
            ShellExecuteA Me.hWnd, "open", OutFile, vbNullString, vbNullString, 1
         End If
      End If
   End If
End Sub
